<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;

class Order extends Model 
{

    protected $table = 'orders';
    public $timestamps = true;
    protected $fillable = array('client_id', 'restaurant_id', 'cost', 'total', 'commission', 'status');

    public function clients()
    {
        return $this->belongsToMany('App\Model\Client');
    }

    public function restaurant()
    {
        return $this->belongsTo('App\Model\Restaurant');
    }

    public function meals()
    {
        return $this->belongsToMany('App\Model\Meal');
    }

}